function [output_areas ] = LURNZ_Land_Use_Change_Module(Co2price, last_year, output_path, pixel_size )
%
% Module 1 of LURNZ
% The land use change module estimates future land use in dairy farming,
% sheep & beef farming, plantation forestry and scrub at a national level.
%
% According to work by Alex Olssen and Suzi Kerr (2011)
%

% Land Use Change Module (LUCM)
% Code by Simon Anastasiadis : 2011-11-01

%% Inform User Module Beginning

msg = sprintf(' - Land Use Change Module initialized');
disp(msg)

%% Load data

[Coeff_table, co2effect, scrubeffect, allocation, areas, price, share_other, total_endog_area ] ...
    = LUCM1_load_data(pixel_size );

%% Run analysis

[share] = LUCM2_project_land_use_change(Coeff_table, co2effect, scrubeffect, allocation, areas, price, Co2price, last_year, share_other );

%% Save output

[output_areas ] = LUCM3_save_results(output_path, share, areas, Co2price, total_endog_area );

%% Inform User Module Complete

msg = sprintf(' - Land Use Change Module complete');
disp(msg)

end

